
#*********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
#*********************************************************************************

use mdAddrPerlWrapper;

# ********************** LICENSE STRINGS ***********************
#       To unlock the full functionality of Address Object,     
#   please call a sales representative at 1-800-MELISSA ext. 3   
#           (1-800-635-4772 x3) for a license string.           
#        Without a valid license string, AddressCheck will     
#                  only verify Nevada addresses.               
#              REPLACE "DEMO" with LICENSE STRING                    

#   SetLicenseString will also check for a valid license in the 
#   MDADDR_LICENSE(Environment) variable. This allows you to  
#   modify the license without recompiling the project
# **************************************************************

my $LICENSE = "DEMO";

# ********************** DATA FILE PATH  ***********************
# File location path is set to the default Data File location. *
# Change this value if you installed the data files to a       *
# different folder.                                            *
# The Data Files Directory must contain the following files:   *
# mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
# **************************************************************
my $FILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";

#.................................................................................


$addrObj = new mdAddrPerlWrapper::mdAddr();

        
# Set the License String 
$addrObj->SetLicenseString($LICENSE);


# Set paths for data files in Initialize method
$addrObj->SetPathToUSFiles($FILELOC);

# Add-Ons
#$addrObj->SetPathToDPVDataFiles($FILELOC);
#$addrObj->SetPathToLACSLinkDataFiles($FILELOC);
#$addrObj->SetPathToRBDIFiles($FILELOC);
#$addrObj->SetPathToCanadaFiles($FILELOC);

my $InitResult = $addrObj->InitializeDataFiles();
if ($InitResult != 0)
{
	printf $addrObj->GetInitializeErrorString(), "\n";
	die "Cannot Initialize Address Object";	
}

#.................................................................................

# Get the Build number and DB Date
print "\n";
print "========================================================================\n";
print "    ADDRESS OBJECT PERL INTERFACE SAMPLE                         \n";
print "          Build Number: ", $addrObj->GetBuildNumber(), "\n";
print "     Initialize Status: ", $addrObj->GetInitializeErrorString(), "\n";
print "         Database Date: ",$addrObj->GetDatabaseDate() , "\n";
print "       Expiration Date: ", $addrObj->GetExpirationDate(), "\n";
print "========================================================================\n";
print "\n";

#.................................................................................

print "  Enter Address: ";
$address = <>;
print " Enter Address2: ";
$address2 = <>;
print "     Enter City: ";
$city = <>;
print "    Enter State: ";
$state = <>;
print "      Enter Zip: ";
$zip = <>;

$addrObj->ClearProperties();
$addrObj->SetAddress($address);
$addrObj->SetAddress2($address2);
$addrObj->SetCity($city);
$addrObj->SetState($state);
$addrObj->SetZip($zip);

my $result = $addrObj->VerifyAddress();

if($result == 0)
{
	#Error with the Address address
	print "Error String :     ", $addrObj->GetErrorString(), "\n";
}
else
{
	
#.................................................................................
print "\n";
print "== Results ==============================================================\n";
# Results are returned as a delimited string, so we parse the codes...
$Results = $addrObj->GetResults();
if (($Results =~ m/AS01/i) || ($Results =~ m/AS02/i) || ($Results =~ m/AS03/i))
# the address has been verified
{
   if ($Results =~ m/AS01/i)
   {
        print " AS01: Full Address Matched to Postal Database and is deliverable\n";
   }
   if ($Results =~ m/AS02/i)
   {
        print " AS02: Address matched to USPS database but a suite was missing or invalid\n";
   }
   if ($Results =~ m/AS03/i)
	{
		print " AS03: Valid Physical Address, not Serviced by the USPS \n";
	}
}
# Display additional level of verification/comments

if ($Results =~ m/AS09/i)
{
     print " AS09: Foreign Postal Code Detected \n";
}
if ($Results =~ m/AS10/i)
{
     print " AS10: Address Matched to CMRA\n";
}
if ($Results =~ m/AS13/i)
{
     print " AS13: Address has been Updated by LACSLink \n";
}
if ($Results =~ m/AS14/i)
{
     print " AS14: Suite Appended by SuiteLink \n";
}
if ($Results =~ m/AS15/i)
{
     print " AS15: Suite Appended by SuiteFinder \n";
}
if ($Results =~ m/AS16/i)
{
     print " AS16: Address is vacant.\n";
}
if ($Results =~ m/AS17/i)
{
     print " AS17: Alternate delivery.\n";
}
if ($Results =~ m/AS18/i)
{
     print " AS18: DPV processing was terminated artificially created adresses detected.\n";
}
if ($Results =~ m/AS20/i)
{
     print " AS20: Address Deliverable by USPS only \n";
}
if ($Results =~ m/AS21/i)
{
     print " AS21: Alternate Address Suggestion Found\n";
}
if ($Results =~ m/AS22/i)
{
     print " AS22: No Alternate Address Suggestion Found\n";
}
if ($Results =~ m/AS23/i)
{
     print " AS23: Extraneous information found \n";
}	

# there was an error in verifying the address...
if ($Results =~ m/AE/i)
{
	 print " Address could not be verified... \n";
   if ($Results =~ m/AE01/i)
   {
       print " AE01: Zip Code Error \n";
   }
   if ($Results =~ m/AE02/i)
   {
       print " AE02: Unknown Street Error \n";
   }   
   if ($Results =~ m/AE03/i)
   {
      print " AE03: Component Mismatch Error \n";
   }   
   if ($Results =~ m/AE04/i)
   {
      print " AE04: Non-Deliverable Address Error \n";
   }   
   if ($Results =~ m/AE05/i)
   {
      print " AE05: Multiple Match Error \n";
   }   
   if ($Results =~ m/AE06/i)
   {
      print " AE06: Early Warning System Error \n";
   }   
   if ($Results =~ m/AE07/i)
   {
      print " AE07: Missing Minimum Address Input \n";
   }   
   if ($Results =~ m/AE08/i)
   {
      print " AE08: Suite Range Invalid Error\n";
   }   
   if ($Results =~ m/AE09/i)
   {
      print " AE09: Suite Range Missing Error \n";
   }   
   if ($Results =~ m/AE10/i)
   {
      print " AE10: Primary Range Invalid Error \n";
   }   
   if ($Results =~ m/AE11/i)
   {
      print " AE11: Primary Range Missing Error \n";
   }   
   if ($Results =~ m/AE12/i)
   {
      print " AE12: PO, HC, or RR Box Number Invalid \n";
   }   
   if ($Results =~ m/AE13/i)
   {
      print " AE13: PO, HC, or RR Box Number Missing \n";
   }   
   if ($Results =~ m/AE14/i)
   {
      print " AE14: CMRA Secondary Missing Error\n";
   }

# the address could not go through the verifying process
   if ($Results =~ m/AE15/i)
   {
      print " AE15: Demo Mode, valid license required for full processing \n";
   }   
   if ($Results =~ m/AE16/i)
   {
      print " AE16: Expired Database, Please Update\n";
   }
   
   if ($Results =~ m/AE17/i)
   {
      print " AE17: Unnecessary Suite Error \n";
   }   
   if ($Results =~ m/AE19/i)
   {
      print " AE19: Max time for FindSuggestion exceeded \n";
   }   
   if ($Results =~ m/AE20/i)
   {
      print " AE20: FindSuggestion cannot be used\n";
   }
}

# there was a change to the input data
if ($Results =~ m/AC01/i)
{
     print " AC01: ZIP Code Change\n";
}
if ($Results =~ m/AC02/i)
{
     print " AC02: State Change\n";
}
if ($Results =~ m/AC033/i)
{
     print " AC03: City Change \n";
}
if ($Results =~ m/AC04/i)
{
     print " AC04: Base/Alternate Change \n";
}
if ($Results =~ m/AC05/i)
{
     print " AC05: Alias Name Change\n";
}
if ($Results =~ m/AC06/i)
{
     print " AC06: Address1/Address2 Swap\n";
}
if ($Results =~ m/AC07/i)
{
     print " AC07: Address1/Company Swap\n";
}
if ($Results =~ m/AC08/i)
{
     print " AC08: Plus4 Change\n";
}
if ($Results =~ m/AC09/i)
{
     print " AC09: Urbanization Change \n";
}
if ($Results =~ m/AC10/i)
{
     print " AC10: Street Name Change\n";
} 
if ($Results =~ m/AC11/i)
{
     print " AC11: Street Suffix Change\n";
}
if ($Results =~ m/AC12/i)
{
     print " AC12: Street Directional Change \n";
}
if ($Results =~ m/AC13/i)
{
     print " AC13: Suite Name Change\n";
}

  print "\n";
	print "Firm Name:             ", $addrObj->GetCompany(), "\n";
	print "Delivery Address:      ", $addrObj->GetAddress(), "\n";
	print "Delivery Address Xtra: ", $addrObj->GetAddress2(), "\n";
	print "Suite:                 ", $addrObj->GetSuite(), "\n";
	print "City:                  ", $addrObj->GetCity(), "\n";
	print "State:                 ", $addrObj->GetState(), "\n";
	print "Zip:                   ", $addrObj->GetZip(), "\n";
	print "Plus4:                 ", $addrObj->GetPlus4(), "\n";
	print "Delivery Point Code:   ", $addrObj->GetDeliveryPointCode(), "\n";
	print "Delivery Point CD  :   ", $addrObj->GetDeliveryPointCheckDigit(), "\n";
	print "DPV Footnotes:         ", $addrObj->GetDPVFootnotes(), "\n";
	print "Urbanization:          ", $addrObj->GetUrbanization(), "\n";
	print "Abbreviation City:     ", $addrObj->GetCityAbbreviation(), "\n";
	print "CMRA:                  ", $addrObj->GetCMRA(), "\n";
	print "Country Code:          ", $addrObj->GetCountryCode(), "\n";
	print "Fips:                  ", $addrObj->GetCountyFips(), "\n";
	print "County:                ", $addrObj->GetCountyName(), "\n";
	print "Carrier Route:         ", $addrObj->GetCarrierRoute(), "\n";
	print "PMB:                   ", $addrObj->GetPrivateMailbox(), "\n";
	print "Congress District:     ", $addrObj->GetCongressionalDistrict(), "\n";
	print "RBDI:                  ", $addrObj->GetRBDI(), "\n";
	print "LACS:                  ", $addrObj->GetLACS(), "\n";
	print "LACS Link Indicator:   ", $addrObj->GetLACSLinkIndicator(), "\n";
	print "LACS Link Return Code: ", $addrObj->GetLACSLinkReturnCode(), "\n";
	print "Time Zone:             ", $addrObj->GetTimeZone(), "\n";
	print "Time Zone Code:        ", $addrObj->GetTimeZoneCode(), "\n";
	print "Msa:                   ", $addrObj->GetMsa(), "\n";
	print "Pmsa:                  ", $addrObj->GetPmsa(), "\n";
	print "EWS Flag:              ", $addrObj->GetEWSFlag(), "\n";
	print "Urbanization:          ", $addrObj->GetUrbanization(), "\n";
	print "Zip:                   ", $addrObj->GetZip(), "\n";
	print "ZipType:               ", $addrObj->GetZipType(), "\n\n";

  
}
print "========================================================================\n";


